#!/usr/bin/perl

open($file_in, "IpToCountry.csv");
open($file_out, ">geolocation.db");
open($file_loc, ">geolocation_db.gsc");

my @countries = ();
my $country_code = '';
my $country_name = '';
my $ip_first = 0;
my $ip_last = 0;
my $backlog = 0;

LINE: while(<$file_in>) {
	next LINE if /^#/;
	chomp;
	$line = $_;
	@elements = split(',', $line);
	if($country_code eq '') {
		$ip_first = strip2int(@elements[0]);
		$ip_last = strip2int(@elements[1]);
		$country_code = stripquotes(@elements[4]);
		$country_name = stripquotes(@elements[6]);
	}
	else {
		$ip_check = strip2int(@elements[0]);
		$country_c = stripquotes(@elements[4]);
		$country_n = stripquotes(@elements[6]);
		if( ($country_c eq $country_code) && ($ip_check == $ip_last+1) ) {
			$backlog = 1;
			$ip_last = strip2int(@elements[1]);
		}
		else {
			$backlog = 0;
			print $file_out "$ip_first $ip_last $country_code $country_name\n";
			addcountry($country_code, $country_name);
			$ip_first = $ip_check;
			$ip_last = strip2int(@elements[1]);
			$country_code = $country_c;
			$country_name = $country_n;
		}
	}
}

if($backlog == 1) {
	print $file_out "$ip_first $ip_last $country_code $country_name\n";
	addcountry($country_code, $country_name);
}

my @countries_sorted = sort by_code (@countries);

print $file_loc "geoLocalize(country)\n";
print $file_loc "{\n";
print $file_loc "\tif(!isDefined(country)) country = \"UNKNOWN\";\n";
print $file_loc "\n";
print $file_loc "\tswitch(country)\n";
print $file_loc "\t{\n";

foreach my $reca (@countries_sorted) {
	my %rec = %$reca;
	my $country_c = $rec{"code"};
	my $country_n = $rec{"name"};
	print $file_loc "\t\tcase \"$country_c\": return(&\"GEOLOCATION_$country_c\"); // $country_n\n";
}

print $file_loc "\t\tcase \"UNKNOWN\":\n";
print $file_loc "\t\tdefault: return(&\"GEOLOCATION_UNKNOWN\");\n";
print $file_loc "\t}\n";
print $file_loc "}\n";

close $file_in;
close $file_out;
close $file_loc;


sub addcountry
{
	foreach my $reca (@countries) {
		my %rec = %$reca;
		my $country_c = $rec{"code"};
		my $country_n = $rec{"name"};

		if($country_c eq $_[0]) { return 0; }
	}

	print "Adding country code: ", $_[0], " (", $_[1], ")\n";
	push @countries, {code => $_[0], name => $_[1]};

	return 1;
}

sub by_code
{
	my %rec_a = %$a;
	my %rec_b = %$b;
	my $code_a = $rec_a{"code"};
	my $code_b = $rec_b{"code"};

	if ($code_a eq $code_b) { return 0; }
		elsif ($code_a gt $code_b) { return 1; }
			else { return -1; }
}

sub strip2int
{
	return int(stripquotes($_[0]));
}

sub stripquotes
{
	return substr($_[0], 1, length($_[0])-2);
}

sub ip2long
{
  return unpack('N', pack('C4', split('\.', $_[0])));
}

sub int2quad
{
	return join('.',unpack('C4', pack("N", $_[0])));
}
