#!/usr/bin/perl

open($file_in, "country-codes.txt");
open($file_out, ">_ex_monitor_log_geolocalize.gsc");
open($file_str, ">geolocation.str");

my @countries = ();
my $country_code = '';
my $country_name = '';

LINE: while(<$file_in>) {
	next LINE if /^#/;
	chomp;
	$line = $_;

	@elements = split(',', $line);
	$country_name = ucword(trim(@elements[0]));
	$country_code = uc(trim(@elements[1]));
	addcountry($country_code, $country_name);
}

addcountry("ZZ", "Reserved");
my @countries_sorted = sort by_code (@countries);

print $file_out "geoLocalize(country)\n";
print $file_out "{\n";
print $file_out "\tif(!isDefined(country)) country = \"UNKNOWN\";\n";
print $file_out "\n";
print $file_out "\tswitch(country)\n";
print $file_out "\t{\n";

foreach my $reca (@countries_sorted) {
	my %rec = %$reca;
	my $country_c = $rec{"code"};
	my $country_n = $rec{"name"};
	print $file_out "\t\tcase \"$country_c\": return(&\"GEOLOCATION_$country_c\"); // $country_n\n";
}

print $file_out "\t\tcase \"UNKNOWN\":\n";
print $file_out "\t\tdefault: return(&\"GEOLOCATION_UNKNOWN\");\n";
print $file_out "\t}\n";
print $file_out "}\n";


print $file_str "// eXtreme+ geolocation string file\n";
print $file_str "\n";

foreach my $reca (@countries_sorted) {
	my %rec = %$reca;
	my $country_c = $rec{"code"};
	my $country_n = $rec{"name"};
	print $file_str "REFERENCE\t" . $country_c . "\n";
	print $file_str "LANG_ENGLISH\t\"" . $country_n . "\"\n";
	print $file_str "\n";
}

print $file_str "REFERENCE\tUNKNOWN\n";
print $file_str "LANG_ENGLISH\t\"an unknown location\"\n";
print $file_str "\n";
print $file_str "REFERENCE\tWELCOME_GENERAL\n";
print $file_str "LANG_ENGLISH\t\"We welcome a new player from \"\n";
print $file_str "\n";
print $file_str "REFERENCE\tWELCOME_PLAYER\n";
print $file_str "LANG_ENGLISH\t\"We welcome &&1^7 from \"\n";
print $file_str "\n";
print $file_str "ENDMARKER\n";

close $file_in;
close $file_out;
close $file_str;

sub addcountry
{
	foreach my $reca (@countries) {
		my %rec = %$reca;
		my $country_c = $rec{"code"};
		my $country_n = $rec{"name"};
		if($country_c eq $_[0]) { return 0; }
	}

#	print "Adding country code: ", $_[0], " (", $_[1], ")\n";
	push @countries, {code => $_[0], name => $_[1]};

	return 1;
}

sub by_code
{
	my %rec_a = %$a;
	my %rec_b = %$b;
	my $code_a = $rec_a{"code"};
	my $code_b = $rec_b{"code"};

	if ($code_a eq $code_b) { return 0; }
		elsif ($code_a gt $code_b) { return 1; }
			else { return -1; }
}

sub ucword
{
	my $line = '';
	my @words = split(' ', $_[0]);
	foreach $word (@words) {
		my $word = lc($word);
		if($word ne "and" && $word ne "of" && $word ne "the") {
			$word = ucfirst($word);
		}
		$line = $line . $word . ' ';
	}
	return trim($line);
}

sub trim
{
	my $trimmed = $_[0];
	$trimmed =~ s/^\s*(.*?)\s*$/$1/;
	return $trimmed;
}
