$num_args = $#ARGV + 1;
if ($num_args != 2) {
	print "ERROR: not enough parameters to continue (process_arena.pl)";
	exit;
}

$dir=$ARGV[0];
$fileout=$ARGV[1];
$fileout_fh = open_file_write($fileout);

opendir(DIR, $dir);
while (my $file = readdir(DIR)) {
	next unless ($file =~ m/\.arena$/);
	process_file($dir, $file);
}
closedir(DIR);
close_file($fileout_fh);

sub process_file {
	my ($fd, $fn) = @_;
	print "... Processing: $fn\n";
	$fh = open_file($fd . "/" . $fn);

	$MAP_NAME = "";
	$MAP_LONG = "";
	$MAP_GAME = "";
	$MAP_CLASS = "";

	foreach $line (<$fh>) {
		$index = index($line, "map");
		if ($index != -1) {
			$chunk = substr($line, $index + 3);
			@chars = split('', $chunk);
			$var = "";
			$var_stage = 0;
			foreach $char (@chars) {
				if ($var_stage == 0 && $char eq '"') {
					$var_stage++;
					next;
				}
				if ($var_stage == 1 && $char eq '"') {
					last;
				}
				$var = $var . $char;
			}
			# remove line endings, spaces and tabs
			$var =~ s/[\n\r\s]+//g;
			$MAP_NAME = lc($var);
			if (is_stock($MAP_NAME) == 1) {
				$MAP_CLASS = "stock";
			} else {
				$MAP_CLASS = "custom";
			}
			#print $MAP_CLASS . "\n";
		}
		$index = index($line, "longname");
		if ($index != -1) {
			$chunk = substr($line, $index + 8);
			@chars = split('', $chunk);
			$var = "";
			$var_stage = 0;
			foreach $char (@chars) {
				if ($var_stage == 0 && $char eq '"') {
					$var_stage++;
					next;
				}
				if ($var_stage == 1 && $char eq '"') {
					last;
				}
				$var = $var . $char;
			}
			# remove line endings and tabs
			$var =~ s/[\n\r\t]+//g;
			$MAP_LONG = trim($var);
			#print $MAP_LONG . "\n";
		}
		$index = index($line, "gametype");
		if ($index != -1) {
			$chunk = substr($line, $index + 8);
			@chars = split('', $chunk);
			$var = "";
			$var_stage = 0;
			foreach $char (@chars) {
				if ($var_stage == 0 && $char eq '"') {
					$var_stage++;
					next;
				}
				if ($var_stage == 1 && $char eq '"') {
					last;
				}
				$var = $var . $char;
			}
			# remove line endings and tabs
			$var =~ s/[\n\r\t]+//g;
			$MAP_GAME = trim($var);
			#print $MAP_GAME . "\n";
		}

		if ($MAP_NAME ne "" && $MAP_LONG ne "" && $MAP_CLASS ne "") {
			$fileline = $MAP_NAME . "#" . $MAP_LONG . "#" . $MAP_CLASS . "\n";
			print $fileout_fh $fileline;
			$MAP_NAME = "";
			$MAP_LONG = "";
			$MAP_GAME = "";
			$MAP_CLASS = "";
		}
	}

	close_file($fh);

}

sub trim($) {
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}

sub is_stock {
	my ($fn) = shift;
	if ($fn eq "mp_breakout") { return 1; }
	if ($fn eq "mp_brecourt") { return 1; }
	if ($fn eq "mp_burgundy") { return 1; }
	if ($fn eq "mp_carentan") { return 1; }
	if ($fn eq "mp_dawnville") { return 1; }
	if ($fn eq "mp_decoy") { return 1; }
	if ($fn eq "mp_downtown") { return 1; }
	if ($fn eq "mp_harbor") { return 1; }
	if ($fn eq "mp_farmhouse") { return 1; }
	if ($fn eq "mp_leningrad") { return 1; }
	if ($fn eq "mp_matmata") { return 1; }
	if ($fn eq "mp_railyard") { return 1; }
	if ($fn eq "mp_toujane") { return 1; }
	if ($fn eq "mp_trainstation") { return 1; }
	if ($fn eq "mp_rhine") { return 1; }
	return 0;
}

sub open_file {
	my ($fn, $fm) = shift;
	open my $fh, $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub open_file_write {
	my ($fn, $fm) = shift;
	open my $fh, '>', $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub open_file_append {
	my ($fn, $fm) = shift;
	open my $fh, '>>', $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub close_file {
	my ($fh) = shift;
	close($fh);
}
