$num_args = $#ARGV + 1;
if ($num_args != 3) {
	print "ERROR: not enough parameters to continue (process_gallery.pl)";
	exit;
}

$filein=$ARGV[0];
$fileout=$ARGV[1];
$dirout=$ARGV[2];
$filein_fh = open_file($filein);
$fileout_fh = open_file_write($fileout);

print_header($fileout_fh);
@filecontents = <$filein_fh>;
$lineno = 0;
for $i (1..scalar(@filecontents)) {
	@linecontents = split("#", $filecontents[$i-1]);
	$map = $linecontents[0];
	chomp $map;
	$name = $linecontents[1];
	chomp $name;
	$pack = $linecontents[2];
	chomp $pack;
	$filename = $dirout . "/" . $map . ".jpg";
	if (-e $filename) {
		print "... Processing $filename\n";
		$lineno++;
		if ($lineno%3 == 1) { print_openline($fileout_fh); }
		$title = "<b>$name</b> ($map in collection <b>$pack</b>)";
		$title_notag = "$name ($map in collection $pack)";
		$alt = "$name (Click to zoom and browse other maps in this collection)";

		$descr1 = "<font class=\"descrmap\"><b>Map #$lineno</b></font><br>";
		$descr2 = "<a class=\"highslide\" href=\"images/large/$map.jpg\" title=\"$title_notag\" onclick=\"return hs.expand(this, { slideshowGroup: '$pack' })\"><img src=\"images/$map.jpg\" alt=''/></a><div class=\"highslide-caption\">$title</div><br>";
		$descr3 = "<font class=\"descrmain\">$map</font><br>";
		$descr4 = "<font class=\"descrsub\">($pack)</font><br>&nbsp;<br>";

		print_cell($fileout_fh, $descr1, $descr2, $descr3, $descr4);
		if ($lineno%3 == 0) { print_closeline($fileout_fh); }
	}
}

$remaining_cells = 3 - $lineno%3;
if ($remaining_cells != 3) {
	for $i (1..$remaining_cells) {
		print_cell($fileout_fh, "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;");
	}
	print_closeline($fileout_fh);
}
print_footer($fileout_fh);

close_file($fileout_fh);
close_file($filein_fh);

sub open_file {
	my ($fn, $fm) = @_;
	open my $fh, $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub open_file_write {
	my ($fn, $fm) = @_;
	open my $fh, '>', $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub open_file_append {
	my ($fn, $fm) = @_;
	open my $fh, '>>', $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub close_file {
	my ($fh) = @_;
	close($fh);
}

sub print_header {
	my ($fh) = @_;
	print $fh "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
	print $fh "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n";
	print $fh "	<head>\n";
	print $fh "	<title>eXtreme+ GamerZ Map Gallery</title>\n";
	print $fh "	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n";
	print $fh "	<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">\n";

	print $fh "	<script type=\"text/javascript\" src=\"highslide/highslide-with-gallery.js\"></script>\n";
	print $fh "	<link rel=\"stylesheet\" type=\"text/css\" href=\"highslide/highslide.css\" />\n";
	print $fh "	<!--[if lt IE 7]>\n";
	print $fh "	<link rel=\"stylesheet\" type=\"text/css\" href=\"highslide/highslide-ie6.css\" />\n";
	print $fh "	<![endif]-->\n";
	print $fh "	<link rel=\"stylesheet\" type=\"text/css\" href=\"gallery.css\" media=\"screen\" />\n";

	print $fh "	<script type=\"text/javascript\">\n";
	print $fh "	hs.align = 'center';\n";
	print $fh "	hs.transitions = ['expand', 'crossfade'];\n";
	print $fh "	hs.fadeInOut = true;\n";
	print $fh "	hs.dimmingOpacity = 0.8;\n";
	print $fh "	hs.outlineType = 'rounded-white';\n";
	print $fh "	hs.captionEval = 'this.thumb.alt';\n";
	print $fh "	hs.marginTop = 15;\n";
	print $fh "	hs.numberPosition = 'caption';\n";
	print $fh "	hs.addSlideshow({\n";
	print $fh "		interval: 5000,\n";
	print $fh "		repeat: false,\n";
	print $fh "		useControls: true,\n";
	print $fh "		overlayOptions: {\n";
	print $fh "			className: 'text-controls',\n";
	print $fh "			position: 'top center',\n";
	print $fh "			relativeTo: 'viewport',\n";
	print $fh "			offsetY: 80\n";
	print $fh "		},\n";
	print $fh "		thumbstrip: {\n";
	print $fh "			position: 'top center',\n";
	print $fh "			mode: 'horizontal',\n";
	print $fh "			relativeTo: 'viewport',\n";
	print $fh "			offsetY: 20\n";
	print $fh "		}\n";
	print $fh "	});\n";
	print $fh "	</script>\n";

	print $fh "	</head>\n";
	print $fh "\n";
	print $fh "	<body bgcolor=\"\" text=\"\" link=\"\" vlink=\"\">\n";
	print $fh "		<table width=\"80%\" border=\"0\" cellpadding=\"2\" cellspacing=\"2\" align=\"center\">\n";
}

sub print_footer {
	my ($fh) = @_;
	print $fh "		</table>\n";
	print $fh "	</body>\n";
	print $fh "</html>\n";
}

sub print_openline {
	my ($fh) = @_;
	print $fh "			<tr>\n";
}

sub print_cell {
	my ($fh, $descr1, $descr2, $descr3, $descr4) = @_;
	print $fh "				<td width=\"370\" height=\"239\" align=\"center\">\n";
	print $fh "					$descr1\n";
	print $fh "					$descr2\n";
	print $fh "					$descr3\n";
	print $fh "					$descr4\n";
	print $fh "				</td>\n";
}

sub print_closeline {
	my ($fh) = @_;
	print $fh "			</tr>\n";
}
