$num_args = $#ARGV + 1;
if ($num_args != 2) {
	print "ERROR: not enough parameters to continue (process_maps.pl)";
	exit;
}

$filein=$ARGV[0];
$filein_fh = open_file($filein);
$fileout=$ARGV[1];
$fileout_fh = open_file_write($fileout);

foreach $line (<$filein_fh>) {
	# remove line endings and tabs
	$line =~ s/[\n\r\t]+//g;
	# remove COD2 color codes
	$line =~ s/\^[0-9]//g;
	# replace ampersand with "and" as it will mess up the batch process
	$line =~ s/&/and/;
	# replace (back)slashes, pipe and caret characters with whitespace as they mess up the batch process
	$line =~ s/[\\\/\^|]/ /g;
	# replace offending characters with hooked bracket as they mess up the batch process
	$line =~ s/[\(\<\{]/\[/g;
	$line =~ s/[\)\>\}]/\]/g;
	# replace repeated hooked brackets with single ones
	$line =~ s/\[+/\[/g;
	$line =~ s/\]+/\]/g;
	# replace repeated spaces with single ones
	$line =~ s/ +/ /g;
	$fileline = trim($line) . "\n";
	print $fileout_fh $fileline;
}
close_file($filein_fh);
close_file($fileout_fh);

sub trim($) {
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}

sub open_file {
	my ($fn, $fm) = shift;
	open my $fh, $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub open_file_write {
	my ($fn, $fm) = shift;
	open my $fh, '>', $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub open_file_append {
	my ($fn, $fm) = shift;
	open my $fh, '>>', $fn or die "ERROR: can't open '$fn': $!";
	return $fh;
}

sub close_file {
	my ($fh) = shift;
	close($fh);
}
