@echo off

set XTEXT_STAMP=www.mywebsite.com
set XMARK_IMG=watermark.png
set XSTAMP_Y=17
set XSTAMP_GAL_Y=30

set XFONT_MAIN=..\fonts\engeexpa.ttf
set XFONT_MAIN_SIZE=26
set XFONT_MAIN_COLOR=white
set XFONT_SUB=..\fonts\dungeon.ttf
set XFONT_SUB_SIZE=18
set XTEXT_MAPNAME=This is a Test
set XQUALITY=100

rem Make stamp for thumbnails
rem ----------------------------------------------------------------------------
set /A XSTAMP_Y1 = %XSTAMP_Y%
set /A XSTAMP_Y2 = %XSTAMP_Y% - 1
set /A XSTAMP_Y3 = %XSTAMP_Y% + 1

rem Base image
..\im-convert -size 512x256 -gravity south xc:transparent -font %XFONT_SUB% -pointsize %XFONT_SUB_SIZE% -fill black -annotate +0+%XSTAMP_Y1% "%XTEXT_STAMP%" -fill "rgb(111,111,111)" -annotate +2+%XSTAMP_Y3% "%XTEXT_STAMP%" -fill transparent -annotate +1+%XSTAMP_Y2% "%XTEXT_STAMP%" -quality %XQUALITY% stamp-base.png

rem Mask
..\im-convert -size 512x256 -gravity south xc:black -font %XFONT_SUB% -pointsize %XFONT_SUB_SIZE% -fill white -annotate +0+%XSTAMP_Y1% "%XTEXT_STAMP%" -fill white -annotate +2+%XSTAMP_Y3% "%XTEXT_STAMP%" -fill black -annotate +1+%XSTAMP_Y2% "%XTEXT_STAMP%" -quality %XQUALITY% stamp-mask.png

rem Watermark
..\im-convert test.jpg -resize 350x219! test-in.png
..\im-composite -dissolve 25%% -gravity northeast %XMARK_IMG% test-in.png test-wm1.png
..\im-convert test-wm1.png -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_MAIN_SIZE% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XTEXT_MAPNAME%" -stroke none -fill %XFONT_MAIN_COLOR% -annotate -0+24 "%XTEXT_MAPNAME%" -quality 100 test-watermark.png
if exist test-wm1.png del /F test-wm1.png

rem Sample image
..\im-convert test.jpg -resize 350x219! -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_MAIN_SIZE% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XTEXT_MAPNAME%" -stroke none -fill %XFONT_MAIN_COLOR% -annotate -0+24 "%XTEXT_MAPNAME%" -background none -gravity center -extent 512x256 -quality 100 test-in.png
..\im-convert test-in.png stamp-base.png stamp-mask.png -composite -quality %XQUALITY% -alpha set test-out.png
..\im-convert test-out.png -quality %XQUALITY% -alpha set test-out.psd
if exist test-in.png del /F test-in.png

rem Make stamp for gallery
rem ----------------------------------------------------------------------------
set /A XSTAMP_GAL_Y1 = %XSTAMP_GAL_Y%
set /A XSTAMP_GAL_Y2 = %XSTAMP_GAL_Y% - 1
set /A XSTAMP_GAL_Y3 = %XSTAMP_GAL_Y% + 1

rem Base image
..\im-convert -size 370x239 -gravity south xc:transparent -font %XFONT_SUB% -pointsize %XFONT_SUB_SIZE% -fill black -annotate +0+%XSTAMP_GAL_Y1% "%XTEXT_STAMP%" -fill "rgb(111,111,111)" -annotate +2+%XSTAMP_GAL_Y3% "%XTEXT_STAMP%" -fill transparent -annotate +1+%XSTAMP_GAL_Y2% "%XTEXT_STAMP%" -quality %XQUALITY% stamp-base-gallery.png

rem Mask
..\im-convert -size 370x239 -gravity south xc:black -font %XFONT_SUB% -pointsize %XFONT_SUB_SIZE% -fill white -annotate +0+%XSTAMP_GAL_Y1% "%XTEXT_STAMP%" -fill white -annotate +2+%XSTAMP_GAL_Y3% "%XTEXT_STAMP%" -fill black -annotate +1+%XSTAMP_GAL_Y2% "%XTEXT_STAMP%" -quality %XQUALITY% stamp-mask-gallery.png

rem Sample image
..\im-convert test.jpg -resize 350x219! -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_MAIN_SIZE% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XTEXT_MAPNAME%" -stroke none -fill %XFONT_MAIN_COLOR% -annotate -0+24 "%XTEXT_MAPNAME%" -quality 100 test-in-gallery.png
..\im-convert test-in-gallery.png stamp-base-gallery.png stamp-mask-gallery.png -composite -quality %XQUALITY% test-out-gallery.png
if exist test-in-gallery.png del /F test-in-gallery.png
