@echo off
verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto ERROR_EXT

rem ************************************
rem DEFAULTS
rem ************************************
echo [] Setting defaults
set XPROJECT=x2
set XGRAPHEXT=jpg
set XVERBOSE=1
set XPAUSE=0
set XTAG_LONG=1
set XQUALITY=100
set XFONT_SIZE_THS=22
set XFONT_SIZE_THB=26
set XFONT_SIZE_LRG=40
set XFONT_COLOR=white
set XTEXT_CA1=NO IMAGE
set XTEXT_CA2=AVAILABLE
set XRESIZE=

rem ************************************
rem PERSONAL SETTINGS
rem ************************************
echo [] Applying personal settings
call project.cmd

rem ************************************
rem PARAMETER HANDLING
rem ************************************
set XCLEAN=0
:PROCESS_ARG
if "%1"=="" goto PROCESS_INIT
if "%1"=="/?" goto ARG_SYNTAX
if "%1"=="-?" goto ARG_SYNTAX
if /I "%1"=="+v" goto ARG_VERBOSE_ON
if /I "%1"=="-v" goto ARG_VERBOSE_OFF
if /I "%1"=="+p" goto ARG_PAUSE_ON
if /I "%1"=="-p" goto ARG_PAUSE_OFF
if /I "%1"=="+clean" goto ARG_CLEAN
echo ... unknown parameter %1 ignored
:ARG_NEXT
shift
goto PROCESS_ARG
:ARG_VERBOSE_ON
echo ... Verbose: ON
set XVERBOSE=1
goto ARG_NEXT
:ARG_VERBOSE_OFF
echo ... Verbose: OFF
set XVERBOSE=0
goto ARG_NEXT
:ARG_PAUSE_ON
echo ... Pause: ON
set XPAUSE=1
goto ARG_NEXT
:ARG_PAUSE_OFF
echo ... Pause: OFF
set XPAUSE=0
goto ARG_NEXT
:ARG_CLEAN
echo ... Clean: ON
set XCLEAN=1
goto ARG_NEXT
:ARG_SYNTAX
echo.
echo Syntax: make-gallery.cmd [ /? /v[+/-] /p[+/-] /c]
echo       +v : verbose ON.
echo       -v : verbose OFF (default).
echo       +p : pause ON.
echo       -p : pause OFF (default).
echo   +clean : clean up.
goto END

rem ************************************
rem INITIALIZATION
rem ************************************
:PROCESS_INIT
echo [] Setting up environment
set XDIR_CUR=%~dp0%
set XDIR_BIN=%XDIR_CUR%bin
set XDIR_PIC=%XDIR_CUR%repository\pictures
set XDIR_PRJ=%XDIR_CUR%projects\%XPROJECT%
set XDIR_GAL=%XDIR_PRJ%\gallery
set XDIR_THB=%XDIR_GAL%\images
set XDIR_LRG=%XDIR_GAL%\images\large
set XFILE_HTML=%XDIR_GAL%\gallery.html
set XFILE_MAP=%XDIR_PRJ%\maps.txt
set XFILE_PIC=%XDIR_PRJ%\maps-gallery-pic.txt
set XFILE_ERR=%XDIR_PRJ%\maps-gallery-nopic.txt
set XFONT_MAIN=%XDIR_BIN%\fonts\engeexpa.ttf
if "%XCLEAN%"=="1" goto CLEANUP
set XSTAGE=0

rem ************************************
rem ENVIRONMENT CHECKS
rem ************************************
:PROCESS_CHECK
echo [] Checking environment
if not exist "%XDIR_BIN%" goto ERROR_BIN
if not exist "%XDIR_BIN%\im-convert.exe" goto ERROR_BIN
if not exist "%XDIR_BIN%\perl.exe" goto ERROR_BIN
if not exist "%XDIR_PIC%" goto ERROR_PIC
if not exist "%XDIR_PRJ%" md "%XDIR_PRJ%"
if not exist "%XDIR_PRJ%" goto ERROR_PRJ
if not exist "%XDIR_GAL%" md "%XDIR_GAL%"
if not exist "%XDIR_GAL%" goto ERROR_GAL
if not exist "%XDIR_THB%" md "%XDIR_THB%"
if not exist "%XDIR_THB%" goto ERROR_THB
if not exist "%XDIR_LRG%" md "%XDIR_LRG%"
if not exist "%XDIR_LRG%" goto ERROR_LRG
if not exist "%XDIR_LRG%" md "%XDIR_LRG%"
if exist "%XFILE_PIC%" del /F "%XFILE_PIC%"
if exist "%XFILE_ERR%" del /F "%XFILE_ERR%"
if exist "%XFILE_HTML%" del /F "%XFILE_HTML%"

rem ************************************
rem MAIN PROCESS
rem ************************************
:PROCESS_START
echo [] Validating map list
if not exist "%XFILE_MAP%" goto ERROR_MAPLIST
"%XDIR_BIN%\perl.exe" %XDIR_BIN%\process_maps.pl %XFILE_MAP% %XFILE_MAP%.checked
if not exist "%XFILE_MAP%.checked" goto ERROR_MAPLIST

rem ************************************
rem STAGE SELECTION
rem ************************************
:STAGE_SELECT
set /A XSTAGE+=1
if %XSTAGE% EQU 1 (
	echo [] Stage 1: processing stock maps
	set XDIR_STG=stock
)
if %XSTAGE% EQU 2 (
	echo [] Stage 2: processing custom maps
	set XDIR_STG=custom
)
if %XSTAGE% GTR 2 goto END

:STAGE_CHECK
if not exist "%XDIR_PIC%\%XDIR_STG%" (
	echo.
	echo ERROR: Could not find folder for map pictures
	echo Folder: %XDIR_PIC%\%XDIR_STG%
	echo Skipping stage...
	goto STAGE_SELECT
)
echo [] Checking source files
echo ... Processing
for /F "tokens=1,2* delims=#" %%i in (%XFILE_MAP%.checked) do (
	if %XSTAGE% EQU 1 ( if "%%k"=="stock" (
		if not exist "%XDIR_PIC%\%XDIR_STG%\%%i.%XGRAPHEXT%" (
			echo %%i#%%j#%%k>>%XFILE_ERR%
		) else (
			echo %%i#%%j#%%k>>%XFILE_PIC%
		)
	))
	if %XSTAGE% EQU 2 ( if not "%%k"=="stock" (
		if not exist "%XDIR_PIC%\%XDIR_STG%\%%i.%XGRAPHEXT%" (
			echo %%i#%%j#%%k>>%XFILE_ERR%
		) else (
			echo %%i#%%j#%%k>>%XFILE_PIC%
		)
	))
)

:STAGE_START
rem ************************************
rem PROCESSING
rem ************************************
:TAG_CHECK
if not exist "%XFILE_PIC%" goto STAGE_SELECT
:TAG_LOOP
echo [] Framing, resizing and tagging
if %XSTAGE% EQU 1 (
	echo ... Removing old files
	if exist "%XDIR_THB%\*.jpg" del /F "%XDIR_THB%\*.jpg"
	if exist "%XDIR_LRG%\*.jpg" del /F "%XDIR_LRG%\*.jpg"
)
echo ... Processing
for /F "tokens=1,2* delims=#" %%i in (%XFILE_PIC%) do (
	if %XSTAGE% EQU 1 ( if "%%k"=="stock" (
		call :SRC2TAG %%i .%XGRAPHEXT%
	))
	if %XSTAGE% EQU 2 ( if not "%%k"=="stock" (
		call :SRC2TAG %%i .%XGRAPHEXT%
	))
)

:STAGE_END
if %XSTAGE% EQU 1 goto STAGE_SELECT

rem ************************************
rem CREATING HTML
rem ************************************
:HTML
echo [] Creating HTML gallery code
"%XDIR_BIN%\perl.exe" %XDIR_BIN%\process_gallery.pl %XFILE_MAP%.checked %XFILE_HTML% %XDIR_THB%

rem ************************************
rem COPYING GALLERY SUPPORT FILES
rem ************************************
if not exist "%XDIR_GAL%\gallery.css" (
	echo [] Copying gallery support files
	"%XDIR_BIN%\7za.exe" x -y -o"%XDIR_GAL%" "%XDIR_BIN%\gallery-base.zip" >NUL
)

:CLEANUP
echo [] Cleaning up
if not %XCLEAN%!==1! goto CLEAN_ENV

echo ... Removing gallery files
if exist "%XDIR_GAL%" rd /S /Q "%XDIR_GAL%"
echo ... Removing reference files
if exist "%XFILE_PIC%" del /F "%XFILE_PIC%"
if exist "%XFILE_ERR%" del /F "%XFILE_ERR%"
if exist "%XFILE_HTML%" del /F "%XFILE_HTML%"

:CLEAN_ENV
endlocal
goto END

rem ************************************
rem CONVERSION PROCEDURES
rem ************************************
:SRC2TAG
if "%XVERBOSE%"=="1" (
	echo ... Tag %XDIR_PIC%\%XDIR_STG%\%1%2
)
if "%XMARK_IMG%"=="" (
	if "%XTAG_LONG%"=="1" (
		call :FIND_LONG %1
		call :STR_LENGTH
		call :SRC2TAG_LONG %1 %2
	) else (
		call :STR_LENGTH %1
		call :SRC2TAG_SHORT %1 %2
	)
) else (
	if "%XTAG_LONG%"=="1" (
		call :FIND_LONG %1
		call :STR_LENGTH
		call :SRC2TAG_MRKL %1 %2
	) else (
		call :STR_LENGTH %1
		call :SRC2TAG_MRKS %1 %2
	)
)
goto :EOF

:STR_LENGTH
if "%1" == "" (
	set #=%XMAP_LONG%
) else (
	set #=%1
)
set XLENGTH=0
:STR_LENGTH_LOOP
if defined # (
	set #=%#:~1%
	set /A XLENGTH += 1
	goto STR_LENGTH_LOOP
)
goto :EOF

:SRC2TAG_LONG
if %XLENGTH% GTR 28 (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219 -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THS% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%XMAP_LONG%" -quality 100 "%XDIR_THB%\%1-tmp.png"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219 -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THB% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%XMAP_LONG%" -quality 100 "%XDIR_THB%\%1-tmp.png"
)
"%XDIR_BIN%\im-convert.exe" "%XDIR_THB%\%1-tmp.png" "%XDIR_BIN%\stamp\stamp-base-gallery.png" "%XDIR_BIN%\stamp\stamp-mask-gallery.png" -composite -quality 100 "%XDIR_THB%\%1%2"
if exist "%XDIR_THB%\%1-tmp%2" del /F "%XDIR_THB%\%1-tmp.png"
if "%XRESIZE%"=="" (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -mattecolor "rgb(32,32,32)" -crop -20-20 -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_LRG% -stroke "#000C" -strokewidth 2 -annotate -0+44 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+44 "%XMAP_LONG%" -quality %XQUALITY% "%XDIR_LRG%\%1%2"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -mattecolor "rgb(32,32,32)" -resize %XRESIZE% -crop -20-20 -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_LRG% -stroke "#000C" -strokewidth 2 -annotate -0+44 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+44 "%XMAP_LONG%" -quality %XQUALITY% "%XDIR_LRG%\%1%2"
)
goto :EOF

:SRC2TAG_SHORT
if %XLENGTH% GTR 28 (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219 -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THS% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%1" -quality 100 "%XDIR_THB%\%1-tmp.png"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219 -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THB% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%1" -quality 100 "%XDIR_THB%\%1-tmp.png"
)
"%XDIR_BIN%\im-convert.exe" "%XDIR_THB%\%1-tmp.png" "%XDIR_BIN%\stamp\stamp-base-gallery.png" "%XDIR_BIN%\stamp\stamp-mask-gallery.png" -composite -quality 100 "%XDIR_THB%\%1%2"
if exist "%XDIR_THB%\%1-tmp%2" del /F "%XDIR_THB%\%1-tmp.png"
if "%XRESIZE%"=="" (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -mattecolor "rgb(32,32,32)" -crop -20-20 -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_LRG% -stroke "#000C" -strokewidth 2 -annotate -0+44 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+44 "%1" -quality %XQUALITY% "%XDIR_LRG%\%1%2"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -mattecolor "rgb(32,32,32)" -resize %XRESIZE% -crop -20-20 -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_LRG% -stroke "#000C" -strokewidth 2 -annotate -0+44 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+44 "%1" -quality %XQUALITY% "%XDIR_LRG%\%1%2"
)
goto :EOF

:SRC2TAG_MRKL
"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219 -quality 100 "%XDIR_THB%\%1-tmp.png"
"%XDIR_BIN%\im-composite.exe" -dissolve 25%% -gravity northeast "%XDIR_BIN%\stamp\%XMARK_IMG%" "%XDIR_THB%\%1-tmp.png" -quality 100 "%XDIR_THB%\%1-mrk.png"
if %XLENGTH% GTR 28 (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_THB%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THS% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%XMAP_LONG%" -quality 100 "%XDIR_THB%\%1%2"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_THB%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THB% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%XMAP_LONG%" -quality 100 "%XDIR_THB%\%1%2"
)
if exist "%XDIR_THB%\%1-tmp.png" del /F "%XDIR_THB%\%1-tmp.png"
if exist "%XDIR_THB%\%1-mrk.png" del /F "%XDIR_THB%\%1-mrk.png"
if "%XRESIZE%"=="" (
	"%XDIR_BIN%\im-composite.exe" -dissolve 25%% -gravity northeast "%XDIR_BIN%\stamp\%XMARK_IMG%" -resize 200%% "%XDIR_PIC%\%XDIR_STG%\%1%2" -quality 100 "%XDIR_THB%\%1-mrk.png"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize %XRESIZE% -quality 100 "%XDIR_THB%\%1-lrg.png"
	"%XDIR_BIN%\im-composite.exe" -dissolve 25%% -gravity northeast "%XDIR_BIN%\stamp\%XMARK_IMG%" -resize 200%% "%XDIR_THB%\%1-lrg.png" -quality 100 "%XDIR_THB%\%1-mrk.png"
)
"%XDIR_BIN%\im-convert.exe" "%XDIR_THB%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_LRG% -stroke "#000C" -strokewidth 2 -annotate -0+44 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+44 "%XMAP_LONG%" -quality %XQUALITY% "%XDIR_LRG%\%1%2"
if exist "%XDIR_THB%\%1-lrg.png" del /F "%XDIR_THB%\%1-lrg.png"
if exist "%XDIR_THB%\%1-mrk.png" del /F "%XDIR_THB%\%1-mrk.png"
goto :EOF

:SRC2TAG_MRKS
"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219 -quality 100 "%XDIR_THB%\%1-tmp.png"
"%XDIR_BIN%\im-composite.exe" -dissolve 25%% -gravity northeast "%XDIR_BIN%\stamp\%XMARK_IMG%" "%XDIR_THB%\%1-tmp.png" -quality 100 "%XDIR_THB%\%1-mrk.png"
if %XLENGTH% GTR 28 (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_THB%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THS% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%1" -quality 100 "%XDIR_THB%\%1%2"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_THB%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THB% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%1" -quality 100 "%XDIR_THB%\%1%2"
)
if exist "%XDIR_THB%\%1-tmp.png" del /F "%XDIR_THB%\%1-tmp.png"
if exist "%XDIR_THB%\%1-mrk.png" del /F "%XDIR_THB%\%1-mrk.png"
if "%XRESIZE%"=="" (
	"%XDIR_BIN%\im-composite.exe" -dissolve 25%% -gravity northeast "%XDIR_BIN%\stamp\%XMARK_IMG%" -resize 200%% "%XDIR_PIC%\%XDIR_STG%\%1%2" -quality 100 "%XDIR_THB%\%1-mrk.png"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize %XRESIZE% -quality 100 "%XDIR_THB%\%1-lrg.png"
	"%XDIR_BIN%\im-composite.exe" -dissolve 25%% -gravity northeast "%XDIR_BIN%\stamp\%XMARK_IMG%" -resize 200%% "%XDIR_THB%\%1-lrg.png" -quality 100 "%XDIR_THB%\%1-mrk.png"
)
"%XDIR_BIN%\im-convert.exe" "%XDIR_THB%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_LRG% -stroke "#000C" -strokewidth 2 -annotate -0+44 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+44 "%1" -quality %XQUALITY% "%XDIR_LRG%\%1%2"
if exist "%XDIR_THB%\%1-lrg.png" del /F "%XDIR_THB%\%1-lrg.png"
if exist "%XDIR_THB%\%1-mrk.png" del /F "%XDIR_THB%\%1-mrk.png"
goto :EOF

:FIND_LONG
set XMAP_LONG=[No Description Available]
for /F "tokens=1,2* delims=#" %%i in (%XFILE_MAP%.checked) do (
	if "%%i"=="%1" (
		set XMAP_LONG=%%j
	)
)
goto :EOF

rem ************************************
rem ERROR HANDLING
rem ************************************
:ERROR_EXT
echo.
echo ERROR: Unable to activate Script Command Extensions!
goto END_PAUSE

:ERROR_BIN
echo.
echo ERROR: One of the required tools or the entire "bin" folder is missing!
echo Folder: "%XDIR_BIN%"
goto END_PAUSE

:ERROR_MAPLIST
echo.
echo ERROR: The map list does not exist. Either create one manually, or start
echo the "make" process and agree to execute the arena file extracting process.
echo File: "%XFILE_MAP%"
goto END_PAUSE

:ERROR_PIC
echo.
echo ERROR: Could not find root folder for map pictures!
echo Folder: "%XDIR_PIC%"
goto END_PAUSE

:ERROR_PRJ
echo.
echo ERROR: Could not create project folder!
echo Folder: "%XDIR_PRJ%"
goto END_PAUSE

:ERROR_GAL
echo.
echo ERROR: Could not create folder for gallery!
echo Folder: "%XDIR_GAL%"
goto END_PAUSE

:ERROR_THB
echo.
echo ERROR: Could not create folder for gallery thumbnails!
echo Folder: "%XDIR_THB%"
goto END_PAUSE

:ERROR_LRG
echo.
echo ERROR: Could not create folder for gallery images!
echo Folder: "%XDIR_LRG%"
goto END_PAUSE

rem ************************************
rem CLOSING
rem ************************************
:END_PAUSE
pause
goto :EOF

:END
if "%XPAUSE%"=="1" pause
echo [] Done!
