@echo off
verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto ERROR_EXT

rem ************************************
rem DEFAULTS
rem ************************************
echo [] Setting defaults
set XPROJECT=x2
set XPROJECT_MAPS=%~dp0%repository\maps
set XPROJECT_ARENA=1
set XGRAPHEXT=jpg
set XVERBOSE=1
set XPAUSE=0
set XTAG_LONG=1
set XQUALITY=100
set XFONT_SIZE_THS=22
set XFONT_SIZE_THB=26
set XFONT_SIZE_NA=36
set XFONT_COLOR=white
set XTEXT_CA1=NO IMAGE
set XTEXT_CA2=AVAILABLE
set XMARK_IMG=
set XRESIZE=

rem ************************************
rem PERSONAL SETTINGS
rem ************************************
echo [] Applying personal settings
call project.cmd

rem ************************************
rem PARAMETER HANDLING
rem ************************************
set XCLEAN=0
set XTAG=0
:PROCESS_ARG
if "%1"=="" goto PROCESS_INIT
if "%1"=="/?" goto ARG_SYNTAX
if "%1"=="-?" goto ARG_SYNTAX
if /I "%1"=="+v" goto ARG_VERBOSE_ON
if /I "%1"=="-v" goto ARG_VERBOSE_OFF
if /I "%1"=="+p" goto ARG_PAUSE_ON
if /I "%1"=="-p" goto ARG_PAUSE_OFF
if /I "%1"=="+clean" goto ARG_CLEAN
if /I "%1"=="+tag" goto ARG_TAG
echo ... unknown parameter %1 ignored
:ARG_NEXT
shift
goto PROCESS_ARG
:ARG_VERBOSE_ON
echo ... Verbose: ON
set XVERBOSE=1
goto ARG_NEXT
:ARG_VERBOSE_OFF
echo ... Verbose: OFF
set XVERBOSE=0
goto ARG_NEXT
:ARG_PAUSE_ON
echo ... Pause: ON
set XPAUSE=1
goto ARG_NEXT
:ARG_PAUSE_OFF
echo ... Pause: OFF
set XPAUSE=0
goto ARG_NEXT
:ARG_CLEAN
echo ... Clean: ON
set XCLEAN=1
goto ARG_NEXT
:ARG_TAG
echo ... TAG: ON
set XTAG=1
goto ARG_NEXT
:ARG_SYNTAX
echo.
echo Syntax: make.cmd [ /? /v[+/-] /p[+/-] /c]
echo       +v : verbose ON.
echo       -v : verbose OFF (default).
echo       +p : pause ON.
echo       -p : pause OFF (default).
echo   +clean : clean up.
echo     +tag : create tagged files only (skip subsequent steps).
goto END

rem ************************************
rem INITIALIZATION
rem ************************************
:PROCESS_INIT
echo [] Setting up environment
set XDIR_CUR=%~dp0%
set XDIR_BIN=%XDIR_CUR%bin
set XDIR_PIC=%XDIR_CUR%repository\pictures
set XDIR_PRJ=%XDIR_CUR%projects\%XPROJECT%
set XDIR_ARENA=%XDIR_PRJ%\arena
set XDIR_TAG=%XDIR_PRJ%\tag
set XDIR_PSD=%XDIR_PRJ%\psd
set XDIR_DDS=%XDIR_PRJ%\dds
set XDIR_PAK=%XDIR_PRJ%\pack
set XDIR_IWI=%XDIR_PAK%\images
set XDIR_MAT=%XDIR_PAK%\materials
set XFILE_MAP=%XDIR_PRJ%\maps.txt
set XFILE_TMP=%XDIR_PRJ%\maps-ref.tmp
set XFILE_REF=%XDIR_PRJ%\maps-ref.txt
set XFILE_PIC=%XDIR_PRJ%\maps-pic.txt
set XFILE_ERR=%XDIR_PRJ%\maps-nopic.txt
set XFILE_IWD=%XDIR_PRJ%\z_thumb.iwd
set XFILE_GSC=%XDIR_PRJ%\_ex_votethumb.gsc
set XFONT_MAIN=%XDIR_BIN%\fonts\engeexpa.ttf
if "%XCLEAN%"=="1" goto CLEANUP
set XSTAGE=0

rem ************************************
rem ENVIRONMENT CHECKS
rem ************************************
:PROCESS_CHECK
echo [] Checking environment
if not exist "%XDIR_BIN%" goto ERROR_BIN
if not exist "%XDIR_BIN%\im-convert.exe" goto ERROR_BIN
if not exist "%XDIR_BIN%\im-composite.exe" goto ERROR_BIN
if not exist "%XDIR_BIN%\perl.exe" goto ERROR_BIN
if not exist "%XDIR_BIN%\sfk.exe" goto ERROR_BIN
if not exist "%XDIR_BIN%\dds2iwi.exe" goto ERROR_BIN
if not exist "%XDIR_BIN%\7za.exe" goto ERROR_BIN
if not exist "%XDIR_BIN%\material.template" goto ERROR_BIN
if not exist "%XDIR_PIC%" goto ERROR_PIC
if not exist "%XDIR_PRJ%" md "%XDIR_PRJ%"
if not exist "%XDIR_PRJ%" goto ERROR_PRJ
if not exist "%XDIR_TAG%" md "%XDIR_TAG%"
if not exist "%XDIR_TAG%" goto ERROR_TAG
if not exist "%XDIR_PSD%" md "%XDIR_PSD%"
if not exist "%XDIR_PSD%" goto ERROR_PSD
if not exist "%XDIR_DDS%" md "%XDIR_DDS%"
if not exist "%XDIR_DDS%" goto ERROR_DDS
if not exist "%XDIR_PAK%" md "%XDIR_PAK%"
if not exist "%XDIR_PAK%" goto ERROR_PAK
if not exist "%XDIR_IWI%" md "%XDIR_IWI%"
if not exist "%XDIR_IWI%" goto ERROR_IWI
if not exist "%XDIR_MAT%" md "%XDIR_MAT%"
if not exist "%XDIR_MAT%" goto ERROR_MAT
if not exist "%XDIR_BIN%\stamp\%XMARK_IMG%" set XMARK_IMG=
if exist "%XFILE_PIC%" del /F "%XFILE_PIC%"
if exist "%XFILE_ERR%" del /F "%XFILE_ERR%"
if exist "%XFILE_TMP%" del /F "%XFILE_TMP%"
if exist "%XFILE_GSC%" del /F "%XFILE_GSC%"

rem ************************************
rem ARENA EXTRACTION
rem ************************************
if "%XPROJECT_ARENA%"=="0" goto PROCESS_START
echo.
echo This thumbnail creation process relies on a list of maps, which links a map's
echo rotation name to a description, and sets the origin of the map.
echo You can make this list (maps.txt) by extracting arena files from the iwd files
echo found in the folder that is currently set to:
echo "%XPROJECT_MAPS%".
set /P XASK_ARENA=Do you want to extract arena files now [Y/N]:
if /I "%XASK_ARENA%"=="n" goto ARENA_END
:ARENA_CHECK
if not exist "%XPROJECT_MAPS%" goto ERROR_MAPS
if not exist "%XDIR_ARENA%" md "%XDIR_ARENA%"
if not exist "%XDIR_ARENA%" goto ERROR_ARENA
if not exist "%XPROJECT_MAPS%\iw_*.iwd"	copy /Y "%XDIR_BIN%\CoD2maps.arena" "%XDIR_ARENA%\" >NUL
:ARENA_EXTRACT
echo.
echo [] Extracting arena files
echo ... This can take a while. Please be patient!
echo ... Processing
"%XDIR_BIN%\7za.exe" e -y -o"%XDIR_ARENA%" "%XPROJECT_MAPS%\*.iwd" "mp\*.arena" >NUL
:ARENA_PROCESS
echo [] Processing arena files
echo ... Removing old files
if exist "%XFILE_MAP%" del /F "%XFILE_MAP%"
echo ... Processing
"%XDIR_BIN%\perl.exe" %XDIR_BIN%\process_arena.pl %XDIR_ARENA% %XFILE_MAP%
if exist "%XFILE_MAP%" (
	echo.
	echo You can either proceed and process the maps that have been found,
	echo or abort to review and modify the list of maps.
	set /P XASK_ARENA=Do you want to proceed [Y/N]:
	if /I "%XASK_ARENA%"=="n" (
		echo The list can be found at the following location:
		echo "%XFILE_MAP%"
		goto END
	)
) else (
	echo No list has been created. The process will terminate now.
	goto END
)
:ARENA_END
echo.

rem ************************************
rem MAIN PROCESS
rem ************************************
:PROCESS_START
echo [] Validating map list
if not exist "%XFILE_MAP%" goto ERROR_MAPLIST
"%XDIR_BIN%\perl.exe" %XDIR_BIN%\process_maps.pl %XFILE_MAP% %XFILE_MAP%.checked
if not exist "%XFILE_MAP%.checked" goto ERROR_MAPLIST

rem ************************************
rem STAGE SELECTION
rem ************************************
:STAGE_SELECT
set /A XSTAGE+=1
if %XSTAGE% EQU 1 (
	echo [] Stage 1: processing stock maps
	set XDIR_STG=stock
	set XPREFIX=s
)
if %XSTAGE% EQU 2 (
	echo [] Stage 2: processing custom maps
	set XDIR_STG=custom
	set XPREFIX=c
)
if %XSTAGE% GTR 2 goto END

:STAGE_CHECK
if not exist "%XDIR_PIC%\%XDIR_STG%" (
	echo.
	echo ERROR: Could not find folder for map pictures
	echo Folder: %XDIR_PIC%\%XDIR_STG%
	echo Skipping stage...
	goto STAGE_SELECT
)
echo [] Checking source files
echo ... Processing
for /F "tokens=1,2* delims=#" %%i in (%XFILE_MAP%.checked) do (
	if %XSTAGE% EQU 1 ( if "%%k"=="stock" (
		if not exist "%XDIR_PIC%\%XDIR_STG%\%%i.%XGRAPHEXT%" (
			echo %%i#%%j#%%k>>%XFILE_ERR%
		) else (
			echo %%i#%%j#%%k>>%XFILE_PIC%
		)
	))
	if %XSTAGE% EQU 2 ( if not "%%k"=="stock" (
		if not exist "%XDIR_PIC%\%XDIR_STG%\%%i.%XGRAPHEXT%" (
			echo %%i#%%j#%%k>>%XFILE_ERR%
		) else (
			echo %%i#%%j#%%k>>%XFILE_PIC%
		)
	))
)

:STAGE_START
rem ************************************
rem PROCESSING
rem ************************************
:TAG_LOOP
echo [] Framing, resizing and tagging
if not exist "%XDIR_TAG%\%XDIR_STG%" md "%XDIR_TAG%\%XDIR_STG%"
if not %XTAG%!==1! (
	echo ... Removing old files
	if exist "%XDIR_TAG%\%XDIR_STG%\*.%XGRAPHEXT%" del /F "%XDIR_TAG%\%XDIR_STG%\*.%XGRAPHEXT%"
)
echo ... Processing
if %XSTAGE% EQU 1 (
	if "%XGRAPHEXT%"=="jpg" copy /Y "%XDIR_BIN%\s000.jpg" "%XDIR_PIC%\%XDIR_STG%\" >NUL
	if "%XGRAPHEXT%"=="png" copy /Y "%XDIR_BIN%\s000.png" "%XDIR_PIC%\%XDIR_STG%\" >NUL
	call :SRC2TAG s000 .%XGRAPHEXT%
	if not exist "%XFILE_PIC%" goto PSD_LOOP
) else (
	if not exist "%XFILE_PIC%" goto STAGE_SELECT
)
for /F "tokens=1,2* delims=#" %%i in (%XFILE_PIC%) do (
	if %XSTAGE% EQU 1 ( if "%%k"=="stock" (
		call :SRC2TAG %%i .%XGRAPHEXT%
	))
	if %XSTAGE% EQU 2 ( if not "%%k"=="stock" (
		call :SRC2TAG %%i .%XGRAPHEXT%
	))
)
if "%XTAG%"=="1" goto STAGE_END

:PSD_LOOP
echo [] Creating PSD files
if not exist "%XDIR_PSD%\%XDIR_STG%" md "%XDIR_PSD%\%XDIR_STG%"
echo ... Removing old files
if exist "%XDIR_PSD%\*.psd" del /F "%XDIR_PSD%\*.psd"
if exist "%XDIR_PSD%\%XDIR_STG%\*.psd" del /F "%XDIR_PSD%\%XDIR_STG%\*.psd"
echo ... Processing
for %%i in ("%XDIR_TAG%\%XDIR_STG%\*.png") do call :TAG2PSD %%~ni

:DDS_LOOP
echo [] Creating DDS files
if not exist "%XDIR_DDS%\%XDIR_STG%" md "%XDIR_DDS%\%XDIR_STG%"
echo ... Removing old files
if exist "%XDIR_DDS%\%XDIR_STG%\*.dds" del /F "%XDIR_DDS%\%XDIR_STG%\*.dds"
echo ... Processing
set XNO_MAX=0
for %%i in ("%XDIR_PSD%\%XDIR_STG%\*.psd") do call :PSD2DDS %%~ni %%~xi

:IWI_LOOP
echo [] Creating IWI files
echo ... Removing old files
if exist "%XDIR_IWI%\%XPREFIX%???.*" del /F "%XDIR_IWI%\%XPREFIX%???.*"
echo ... Processing
for %%i in ("%XDIR_DDS%\%XDIR_STG%\*.dds") do call :DDS2IWI %%~ni %%~xi

:IWI_MOVE
echo [] Moving IWI files
echo ... Processing
if %XSTAGE% EQU 1 call :GSC_HEAD
set XNO_CUR=0
for %%i in ("%XDIR_DDS%\%XDIR_STG%\*.iwi") do call :IWI2PAK %%~ni %%~xi
if %XSTAGE% EQU 2 call :GSC_FOOT

:MAT_REPL
echo [] Creating material files
echo ... Removing old files
if exist "%XDIR_MAT%\%XPREFIX%???" del /F "%XDIR_MAT%\%XPREFIX%???"
echo ... Processing
if %XSTAGE% EQU 1 (
	copy /Y "%XDIR_BIN%\material.template" "%XDIR_MAT%\%XPREFIX%000" >NUL
	set /A XNO_MAX-=1
)
set XNO_CUR=1
:MAT_LOOP
if %XNO_CUR% GTR %XNO_MAX% goto STAGE_END
set XNO_ADD=
if %XNO_CUR% LSS 10 set XNO_ADD=0
if %XNO_CUR% LSS 100 set XNO_ADD=%XNO_ADD%0
copy /Y "%XDIR_BIN%\material.template" "%XDIR_MAT%\%XPREFIX%%XNO_ADD%%XNO_CUR%" >NUL
if "%XVERBOSE%"=="1" (
	echo ... Patching %XDIR_MAT%\%XPREFIX%%XNO_ADD%%XNO_CUR%
	echo     to reference image %XPREFIX%%XNO_ADD%%XNO_CUR%
)
"%XDIR_BIN%\sfk.exe" rep -nosub -text /s000/%XPREFIX%%XNO_ADD%%XNO_CUR%/ -dir "%XDIR_MAT%" -file %XPREFIX%%XNO_ADD%%XNO_CUR% -yes >NUL
set /A XNO_CUR+=1
goto MAT_LOOP

:STAGE_END
if %XSTAGE% EQU 1 goto STAGE_SELECT
if "%XTAG%"=="1" goto CLEANUP

:IWD_LOOP
echo [] Creating picture pack
echo ... Removing old file
if exist "%XFILE_IWD%" del /F "%XFILE_IWD%"
echo ... Processing
for /D %%i in ("%XDIR_PAK%\*.*") do call :RAW2IWD %%~ni
if not exist "%XFILE_IWD%" goto ERROR_IWD

:REF
echo [] Creating reference file
echo ... Processing
sort %XFILE_TMP% >%XFILE_REF%
if exist "%XFILE_TMP%" del /F "%XFILE_TMP%"

:CLEANUP
echo [] Cleaning up
if not %XCLEAN%!==1! goto CLEAN_ENV

echo ... Removing TAG files
if exist "%XDIR_TAG%" rd /S /Q "%XDIR_TAG%"
echo ... Removing PSD files
if exist "%XDIR_PSD%" rd /S /Q "%XDIR_PSD%"
echo ... Removing DDS files
if exist "%XDIR_DDS%" rd /S /Q "%XDIR_DDS%"
echo ... Removing IWI files
if exist "%XDIR_IWI%" rd /S /Q "%XDIR_IWI%"
echo ... Removing material files
if exist "%XDIR_MAT%" rd /S /Q "%XDIR_MAT%"
if exist "%XDIR_PAK%" rd /S /Q "%XDIR_PAK%"
echo ... Removing reference files
if exist "%XFILE_PIC%" del /F "%XFILE_PIC%"
if exist "%XFILE_ERR%" del /F "%XFILE_ERR%"
if exist "%XFILE_TMP%" del /F "%XFILE_TMP%"
if exist "%XFILE_GSC%" del /F "%XFILE_GSC%"
if exist "%XFILE_REF%" del /F "%XFILE_REF%"
if exist "%XFILE_IWD%" del /F "%XFILE_IWD%"

:CLEAN_ENV
endlocal
goto END

rem ************************************
rem CONVERSION PROCEDURES
rem ************************************
:SRC2TAG
if "%1"=="s000" (
	if "%XVERBOSE%"=="1" (
		echo ... Tagging %XDIR_PIC%\%XDIR_STG%\%1%2
		echo     to %XDIR_TAG%\%XDIR_STG%\%1%2 [CATCH-ALL]
	)
	call :SRC2TAG_CATCH %1 %2
) else (
	if "%XVERBOSE%"=="1" (
		echo ... Tagging %XDIR_PIC%\%XDIR_STG%\%1%2
		echo     to %XDIR_TAG%\%XDIR_STG%\%1%2
	)
	if "%XMARK_IMG%"=="" (
		if "%XTAG_LONG%"=="1" (
			call :FIND_LONG %1
			call :STR_LENGTH
			call :SRC2TAG_LONG %1 %2
		) else (
			call :STR_LENGTH %1
			call :SRC2TAG_SHORT %1 %2
		)
	) else (
		if "%XTAG_LONG%"=="1" (
			call :FIND_LONG %1
			call :STR_LENGTH
			call :SRC2TAG_MRKL %1 %2
		) else (
			call :STR_LENGTH %1
			call :SRC2TAG_MRKS %1 %2
		)
	)
)
goto :EOF

:STR_LENGTH
if "%1" == "" (
	set #=%XMAP_LONG%
) else (
	set #=%1
)
set XLENGTH=0
:STR_LENGTH_LOOP
if defined # (
	set #=%#:~1%
	set /A XLENGTH += 1
	goto STR_LENGTH_LOOP
)
goto :EOF

:SRC2TAG_CATCH
"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219! -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity center -font %XFONT_MAIN% -pointsize %XFONT_SIZE_NA% -stroke "#000C" -strokewidth 2 -annotate -0-20 "%XTEXT_CA1%" -stroke none -fill %XFONT_COLOR% -annotate -0-20 "%XTEXT_CA1%" -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
"%XDIR_BIN%\im-convert.exe" "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" -gravity center -font %XFONT_MAIN% -pointsize 36 -stroke "#000C" -strokewidth 2 -annotate -0+20 "%XTEXT_CA2%" -stroke none -fill %XFONT_COLOR% -annotate -0+20 "%XTEXT_CA2%" -background none -gravity center -extent 512x256 -quality %XQUALITY% "%XDIR_TAG%\%XDIR_STG%\%1.png"
if exist "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" del /F "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
goto :EOF

:SRC2TAG_LONG
if %XLENGTH% GTR 28 (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219! -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THS% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%XMAP_LONG%" -background none -gravity center -extent 512x256 -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219! -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THB% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%XMAP_LONG%" -background none -gravity center -extent 512x256 -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
)
"%XDIR_BIN%\im-convert.exe" "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" "%XDIR_BIN%\stamp\stamp-base.png" "%XDIR_BIN%\stamp\stamp-mask.png" -composite -quality %XQUALITY% "%XDIR_TAG%\%XDIR_STG%\%1.png"
if exist "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" del /F "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
goto :EOF

:SRC2TAG_SHORT
if %XLENGTH% GTR 28 (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219! -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THS% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%1" -background none -gravity center -extent 512x256 -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219! -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THB% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%1" -background none -gravity center -extent 512x256 -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
)
"%XDIR_BIN%\im-convert.exe" "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" "%XDIR_BIN%\stamp\stamp-base.png" "%XDIR_BIN%\stamp\stamp-mask.png" -composite -quality %XQUALITY% "%XDIR_TAG%\%XDIR_STG%\%1.png"
if exist "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" del /F "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
goto :EOF

:SRC2TAG_MRKL
"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219! -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
"%XDIR_BIN%\im-composite.exe" -dissolve 25%% -gravity northeast "%XDIR_BIN%\stamp\%XMARK_IMG%" "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png"
if %XLENGTH% GTR 28 (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THS% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%XMAP_LONG%" -background none -gravity center -extent 512x256 -quality %XQUALITY% "%XDIR_TAG%\%XDIR_STG%\%1.png"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THB% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%XMAP_LONG%" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%XMAP_LONG%" -background none -gravity center -extent 512x256 -quality %XQUALITY% "%XDIR_TAG%\%XDIR_STG%\%1.png"
)
if exist "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" del /F "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
if exist "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png" del /F "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png"
goto :EOF

:SRC2TAG_MRKS
"%XDIR_BIN%\im-convert.exe" "%XDIR_PIC%\%XDIR_STG%\%1%2" -resize 350x219! -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
"%XDIR_BIN%\im-composite.exe" -dissolve 25%% -gravity northeast "%XDIR_BIN%\stamp\%XMARK_IMG%" "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" -quality 100 "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png"
if %XLENGTH% GTR 28 (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THS% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%1" -background none -gravity center -extent 512x256 -quality %XQUALITY% "%XDIR_TAG%\%XDIR_STG%\%1.png"
) else (
	"%XDIR_BIN%\im-convert.exe" "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png" -mattecolor "rgb(32,32,32)" -frame 10x10+2+2 -gravity south -font %XFONT_MAIN% -pointsize %XFONT_SIZE_THB% -stroke "#000C" -strokewidth 2 -annotate -0+24 "%1" -stroke none -fill %XFONT_COLOR% -annotate -0+24 "%1" -background none -gravity center -extent 512x256 -quality %XQUALITY% "%XDIR_TAG%\%XDIR_STG%\%1.png"
)
if exist "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png" del /F "%XDIR_TAG%\%XDIR_STG%\%1-tmp.png"
if exist "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png" del /F "%XDIR_TAG%\%XDIR_STG%\%1-mrk.png"
goto :EOF

:TAG2PSD
if "%XVERBOSE%"=="1" (
	echo ... Converting %XDIR_TAG%\%XDIR_STG%\%1.png
	echo     to %XDIR_PSD%\%XDIR_STG%\%1.psd
)
"%XDIR_BIN%\im-convert.exe" "%XDIR_TAG%\%XDIR_STG%\%1.png" -quality %XQUALITY% -alpha set "%XDIR_PSD%\%XDIR_STG%\%1.psd"
goto :EOF

:PSD2DDS
set /A XNO_MAX+=1
if "%XVERBOSE%"=="1" (
	echo ... Converting %XDIR_PSD%\%XDIR_STG%\%1%2
	echo     to %XDIR_DDS%\%XDIR_STG%\%1.dds
)
"%XDIR_BIN%\nvDXT.exe" -profile "%XDIR_BIN%\cod2dds.dpf" -file "%XDIR_PSD%\%XDIR_STG%\%1%2" -outfile "%XDIR_DDS%\%XDIR_STG%\%1.dds" >NUL
goto :EOF

:DDS2IWI
if "%XVERBOSE%"=="1" (
	echo ... Converting %XDIR_DDS%\%XDIR_STG%\%1%2
	echo     to %XDIR_DDS%\%XDIR_STG%\%1.iwi
)
"%XDIR_BIN%\dds2iwi.exe" "%XDIR_DDS%\%XDIR_STG%\%1%2" >NUL
goto :EOF

:IWI2PAK
if "%1"=="s000" (
	echo _NO_IMAGE_AVAILABLE_ - %1>>%XFILE_TMP%
	move /Y "%XDIR_DDS%\%XDIR_STG%\%1%2" "%XDIR_IWI%\" >NUL
	goto :EOF
)
set /A XNO_CUR+=1
set XNO_ADD=
if %XNO_CUR% LSS 10 set XNO_ADD=0
if %XNO_CUR% LSS 100 set XNO_ADD=%XNO_ADD%0
if "%XVERBOSE%"=="1" (
	echo ... Moving %XDIR_DDS%\%XDIR_STG%\%1%2
	echo     to %XDIR_IWI%\%XPREFIX%%XNO_ADD%%XNO_CUR%%2
)
call :GSC_LINE %1 %XPREFIX%%XNO_ADD%%XNO_CUR%
echo %1 - %XPREFIX%%XNO_ADD%%XNO_CUR%>>%XFILE_TMP%
move /Y "%XDIR_DDS%\%XDIR_STG%\%1%2" "%XDIR_IWI%\%XPREFIX%%XNO_ADD%%XNO_CUR%%2" >NUL
goto :EOF

:RAW2IWD
if "%XVERBOSE%"=="1" (
	echo ... Archiving %XDIR_PAK%\%1
	echo     to %XFILE_IWD%
)
"%XDIR_BIN%\7za.exe" a -r -tzip %XFILE_IWD% "%XDIR_PAK%\%1" >NUL
goto :EOF

:GSC_HEAD
echo getThumbnail(map)>>%XFILE_GSC%
echo {>>%XFILE_GSC%
echo 	switch(map)>>%XFILE_GSC%
echo 	{>>%XFILE_GSC%
goto :EOF

:GSC_LINE
echo 		case "%1": return("%2");>>%XFILE_GSC%
goto :EOF

:GSC_FOOT
echo 		default: return("s000");>>%XFILE_GSC%
echo 	}>>%XFILE_GSC%
echo }>>%XFILE_GSC%
goto :EOF

:FIND_LONG
set XMAP_LONG=[No Description Available]
for /F "tokens=1,2* delims=#" %%i in (%XFILE_MAP%.checked) do (
	if "%%i"=="%1" (
		set XMAP_LONG=%%j
	)
)
goto :EOF

rem ************************************
rem ERROR HANDLING
rem ************************************
:ERROR_EXT
echo.
echo ERROR: Unable to activate Script Command Extensions!
goto END_PAUSE

:ERROR_BIN
echo.
echo ERROR: One of the required tools or the entire "bin" folder is missing!
echo Folder: "%XDIR_BIN%"
goto END_PAUSE

:ERROR_MAPS
echo.
echo ERROR: The project file points to an invalid folder for IWD files!
echo Check the XPROJECT_MAPS setting in the project settings.
echo Folder: "%XPROJECT_MAPS%"
goto END_PAUSE

:ERROR_MAPLIST
echo.
echo ERROR: The map list does not exist. Either create one manually, or restart
echo this process and agree to execute the arena file extracting process.
echo File: "%XFILE_MAP%"
goto END_PAUSE

:ERROR_PIC
echo.
echo ERROR: Could not find root folder for map pictures!
echo Folder: "%XDIR_PIC%"
goto END_PAUSE

:ERROR_PRJ
echo.
echo ERROR: Could not create project folder!
echo Folder: "%XDIR_PRJ%"
goto END_PAUSE

:ERROR_ARENA
echo.
echo ERROR: Could not create folder for arena files!
echo Folder: "%XDIR_ARENA%"
goto END_PAUSE

:ERROR_TAG
echo.
echo ERROR: Could not create folder for tagged files!
echo Folder: "%XDIR_TAG%"
goto END_PAUSE

:ERROR_PSD
echo.
echo ERROR: Could not create folder for PSD files!
echo Folder: "%XDIR_PSD%"
goto END_PAUSE

:ERROR_DDS
echo.
echo ERROR: Could not create folder for DDS files!
echo Folder: "%XDIR_DDS%"
goto END_PAUSE

:ERROR_PAK
echo.
echo ERROR: Could not create folder for archive source!
echo Folder: "%XDIR_PAK%"
goto END_PAUSE

:ERROR_IWI
echo.
echo ERROR: Could not create folder for images!
echo Folder: "%XDIR_IWI%"
goto END_PAUSE

:ERROR_MAT
echo.
echo ERROR: Could not create folder for material files!
echo Folder: "%XDIR_MAT%"
goto END_PAUSE

:ERROR_IWD
echo.
echo ERROR: Could not create IWD archive!
echo File: "%XFILE_IWD%"
goto END_PAUSE

rem ************************************
rem CLOSING
rem ************************************
:END_PAUSE
pause
goto :EOF

:END
if "%XPAUSE%"=="1" pause
echo [] Done!
