@echo off

rem Name of the project.
rem A folder with this name will be created in the projects folder.
rem Do not include spaces or special characters; just a relatively short word.
rem Default: x2

set XPROJECT=x2

rem Folder that holds the IWD files (maps and map packs) for this project.
rem Only used by the arena scanner feature.
rem Do not including a trailing (back)slash, and do use quotation marks, even
rem when it has spaces in it.
rem Default: "repository\maps" in current factory folder
rem Example: set XPROJECT_MAPS=D:\Games\COD2\main

set XPROJECT_MAPS=%~dp0%repository\maps

rem Scan for arena files to make the list of maps (maps.txt).
rem By default, every time you launch make.cmd you will be asked to scan for
rem arena files. If you already scanned for arena files once, and want to edit
rem maps.txt manually from this time on, or you plan to create and maintain the
rem maps list right from the start, you can disable the prompt by setting
rem XPROJECT_ARENA to 0.
rem Default: 1

set XPROJECT_ARENA=1

rem Graphics format of the screenshot files (either jpg or png).
rem All files must have the same format and dimensions. Do not include the dot!
rem Default: jpg

set XGRAPHEXT=jpg

rem To reduce the size of the gallery "zoom" images ("large" folder in gallery),
rem you can set the new dimensions as <width>x<height>, like 960x540 if you
rem want to make full HD (1920x1080) half the size.
rem If you do not want resizing to occur, simply leave it blank.
rem Default: (not set)

set XRESIZE=960x540

rem Color of the map description text that will be stamped on all images.
rem You can use color names, as listed on the following web page:
rem http://www.imagemagick.org/script/color.php
rem You can also use your own RGB setting, formatted as "rgb(R,G,B)", where
rem R, G and B represent red, green and blue in values of 0 to 255. When using
rem this format, make sure you include the opening and trailing quotation marks.
rem Example: set XFONT_COLOR=HotPink1
rem Example: set XFONT_COLOR="rgb(0,200,245)"

set XFONT_COLOR=white

rem Text that should appear on the "catch-all" image for maps that have no
rem image (only applies to map vote thumbnail feature in eXtreme).
rem There are two lines available. Both will be applied.
rem Default: NO IMAGE and AVAILABLE

set XTEXT_CA1=NO IMAGE
set XTEXT_CA2=AVAILABLE

rem By default a watermark will be placed based on text set during the stamp
rem initialization process. If you rather have an image stamped on the images,
rem provide the name of the image here.
rem Do NOT include a path; it MUST reside in the bin\stamp folder!
rem Default: (not set)

set XMARK_IMG=

rem By default the map description (or long name) will be printed on the images.
rem The long name is the second column in the project's maps.txt. For example
rem "Beltot, France" in the line "mp_farmhouse#Beltot, France#stock".
rem If you rather have the image's file name (without its extension) printed on
rem the image, you should set XTAG_LONG to 0.
rem Default: 1

set XTAG_LONG=1

rem Various settings to control the processing scripts.
rem Do NOT change, unless you know what your are doing!

rem Feedback level of script.

set XVERBOSE=1

rem Force a pause after executing the script.

set XPAUSE=0

rem Export quality of images. Reducing image quality will reduces image size by
rem sacrificing image sharpness.

set XQUALITY=100

rem Font size for map's description printed on the image.

set XFONT_SIZE_THB=26

rem Font size for map's description printed on the image in case the
rem description is too long to fit between the borders.

set XFONT_SIZE_THS=22

rem Font size for the large gallery images (when clicking a thumbnail image).

set XFONT_SIZE_LRG=40

rem Font size for the NO IMAGE AVAILABLE image.

set XFONT_SIZE_NA=36
